' VB Script enabling Email functions on Groups or Users objects.    '
' Email can be enabled with or without an Exchange 2000 mailbox     '
' for a user object only.                                           '
'                                                                   '
' Version 1.00 - Alain Lissoir                                      '
' Compaq Computer Corporation - Professional Services - Belgium -   '
'                                                                   '
' Any comments or questions:         EMail:alain.lissoir@compaq.com '

Option Explicit

Const NO_CREATE_MB = 0
Const CREATE_MB = 1

Const OBJECT_ALREADY_MAIL_ENABLED = &h80004005

' ------------------------------------------------------------------------------------------
Private Sub EnableEmailAddress (objObject, _
                                strExchangeComputer, _
                                strOrganization, _
                                strExchangeAdminGroup, _
                                strExchangeStorageGroup, _
                                strExchangeMailboxStore, _
                                boolMB)
Dim objRoot
Dim strRootDomainNC, objRootDomainNC
Dim strConfigNC

Dim strRootDNSDomainName
Dim strRecipient

Dim strSMTPAddress
Dim strX400Address

        Set ObjRoot = GetObject("LDAP://RootDSE")
        strRootDomainNC = objRoot.Get("RootDomainNamingContext")
        strConfigNC = ObjRoot.Get("configurationNamingContext")
        WScript.DisconnectObject ObjRoot
        Set ObjRoot = Nothing

        ' ----------------------------------------------------------------------------------
        Set objRootDomainNC = GetObject("LDAP://" & strRootDomainNC)

        ' Retrieve a constructed property, so 1st we do a GetInfoEx
        objRootDomainNC.GetInfoEx Array("canonicalName"), 0
        strRootDNSDomainName = objRootDomainNC.Get("canonicalName")
        ' Remove the / at the end
        strRootDNSDomainName = Mid (strRootDNSDomainName, 1, Len(strRootDNSDomainName) - 1)

        WScript.DisconnectObject objRootDomainNC
        Set objRootDomainNC = Nothing

	' Just make this to avoid a CDOEXM error if the object is already mail-enabled or mailbox-enabled.
        On Error Resume Next

        ' ----------------------------------------------------------------------------------
        Select Case objObject.Class
               Case "user"
                    If boolMB Then
                       objObject.CreateMailbox "LDAP://" & strAccountComputer & "/" & _
                                               "cn=" & strExchangeMailboxStore  & "," & _
                                               "cn=" & strExchangeStorageGroup & "," & _
                                               "cn=InformationStore," & _
                                               "cn=" & strExchangeComputer & ",cn=Servers," & _
                                               "cn=" & strExchangeAdminGroup & "," & _
                                               "cn=Administrative Groups," & _
                                               "cn=" & strOrganization & "," & _
                                               "cn=Microsoft Exchange,CN=Services," & strConfigNC
                       If Err.Number = OBJECT_ALREADY_MAIL_ENABLED Then 
                          WScript.Echo Err.Description
                          Err.Clear
                       End If
                    Else
                       strRecipient = EliminateSpaces (LCase (objObject.FirstName) & _
                                                            "." & LCase (objObject.LastName))

                       strSMTPAddress = strRecipient & "@" & strRootDNSDomainName
                       strX400Address = "c=" & strCountry & _
                                        ";a= " & _
                                        ";p=" & Left (strOrganization, 16) & _
                                        ";o=Exchange" & _
                                        ";s=" & LCase (objObject.LastName) & _
                                        ";g=" & LCase (objObject.FirstName) & _
                                        ";"

                       ' If mail-enabled object, initialize targetAddress with the SMTP Address
                       objObject.MailEnable "SMTP:" & strSMTPAddress
                       If Err.Number = OBJECT_ALREADY_MAIL_ENABLED Then 
                          WScript.Echo Err.Description
                          Err.Clear
                       End If

                       ' Make this for the X400 address if necessary (instead of SMTP:)
                       ' objObject.MailEnable "X400:" & strX400Address
                       ' If Err.Number = OBJECT_ALREADY_MAIL_ENABLED Then
                       '    WScript.Echo Err.Description
                       '    Err.Clear
                       ' End If
                    End If

               Case "group"                       
                    ' If mail-enabled object, initialize targetAddress with the SMTP Address
                    objObject.MailEnable 
                    If Err.Number = OBJECT_ALREADY_MAIL_ENABLED Then
                       WScript.Echo Err.Description
                       Err.Clear
                    End If

               Case Else
                    Exit Sub
        End Select

        ' Reset the 'On Error Resume Next' statement.
        On Error Goto 0

        objObject.SetInfo

        If objObject.Class = "user" And boolMB Then
           Wscript.Echo "  Successfully created Microsoft " & _
                        "Exchange 2000 Mailbox for user '" & _
                        objObject.Get ("cn") & "'."
        Else
           Wscript.Echo "  Successfully enabled Microsoft Exchange 2000 E-Mail for '" & _
                        objObject.Get ("cn") & "'."
        End If
End Sub

' ------------------------------------------------------------------------------------------
Function EliminateSpaces (strTemp)

Dim strNoSpaceName
Dim intIndice

        For intIndice = 1 To Len (strTemp)
            If Mid(strTemp, intIndice, 1) <> " " Then
               strNoSpaceName = strNoSpaceName & Mid(strTemp, intIndice, 1)
            End IF
        Next

        EliminateSpaces = strNoSpaceName

End Function